| runtime library of mathematical functions for QuickForth

| stack independent functions

macro
: sqrt fsqrt ;
: sin fsin ;
: cos fcos ;
: tan fptan fstpst0 ;
: cotan fsincos fdivrp ;
: arctan fld1 fpatan ;
: arrcotan fld1 fxch fpatan ;
: arcsin fldst0 fldst0 fmulp fld1 fsubrp fsqrt fpatan ;
: arccos fldst0 fldst0 fmulp fld1 fsubrp fsqrt fxch fpatan ;
: log2 fld1 fxch fyl2x ;
: ln fldln2 fxch fyl2x ;
: log10 fldlg2 fxch fyl2x ;
: 2^ fldst0 frndint fxch fsubst1 f2xm1 fld1 faddp fscale ;
: exp fldl2e fmulp m: 2^ ;
| : sinh
| : cosh
| : tanh
| : cotanh
| : arcsinh
| : arccosh
| : arctanh
| : arccotanh

forth
: sqrt sqrt ;
: sin sin ;
: cos cos ;
: tan tan ;
: cotan cotan ;
: arctan arctan ;
: arccotan arccotan ;
: arcsin arcsin ;
: arccos arccos ;
: log2 log2 ;
: ln ln ;
: log10 log10 ;
: 2^ 2^ ;
: exp exp ;

| stack dependent functions

macro
: sumsqr2 fldst0 fmulp fload fldst0 fmulp faddp ;
: sumsqr3 fldst0 fmulp fload fldst0 fmulp fload fldst0 fmulp faddp faddp ;
: hypot2 m: sumsqr2 fsqrt ;
: hypot3 m: sumsqr3 fsqrt ;
: pi fstore fldpi ;
: sincos fsincos fstore ;
: tan2 fptan fstore ;
: arctan2 fload fpatan ;
: log fload fld1 fxch fyl2x fxch fld1 fxch fyl2x fdivp ;
: ^ fload fxch m: log2 fmulp m: 2^ ;

forth
: sumsqr2 sumsqr2 ;
: sumsqr3 sumsqr3 ;
: hypot2 hypot2 ;
: hypot3 hypot3 ;
: pi pi ;
: sincos sincos ;
: tan2 tan2 ;
: arctan2 arctan2 ;
: log log ;
: ^ ^ ;

forth
loc: | random numbers (fibonacci algorithm)
 5 const m
 17 const n
 precision m * const a
 precision n * const b
 b a - const b-a
 var c
 b array rnd_array
 : init_random
   .171226806613001 | initial random numbers - some parts of pi
   .078164062862089
   .955058223172535
   .930381964428810
   .669234603486104
   .488152092096282
   .146951941511609
   .480744623799627
   .065664308602139
   .752384674818467
   .736371787214684
   .995611212902196
   .372978049951059
   .446850352619311
   .730359825349042
   .489608412848862
   .857843838279679 | n initial values!
   rnd_array n for dup f! precision + next drop
 ;
 init_random
 | rnd_array n for dup f@ f. cr precision + next drop
 :: c @ a + b mod rnd_array dup c @ + f@ + f@
    f- fdup f<0 if [ fld1 faddp ] then rnd_array c @ + fdup f!
    c @ precision - dup <0 if b + then c !
 ;
;loc alias random

| first digits of pi (used to initialize pseudorandom generator)

| 3.14159265358979323846264338327950288419716939937510582097494459
| 2307816406286208998628034825342117067982148086513282306647093844
| 6095505822317253594081284811174502841027019385211055596446229489
| 5493038196442881097566593344612847564823378678316527120190914564
| 8566923460348610454326648213393607260249141273724587006606315588
| 1748815209209628292540917153643678925903600113305305488204665213
| 8414695194151160943305727036575959195309218611738193261179310511
| 8548074462379962749567351885752724891227938183011949129833673362
| 4406566430860213949463952247371907021798609437027705392171762931
| 7675238467481846766940513200056812714526356082778577134275778960
| 9173637178721468440901224953430146549585371050792279689258923542
| 0199561121290219608640344181598136297747713099605187072113499999
| 9837297804995105973173281609631859502445945534690830264252230825
| 3344685035261931188171010003137838752886587533208381420617177669
| 1473035982534904287554687311595628638823537875937519577818577805
| 3217122680661300192787661119590921642019893809525720106548586327
| 8865936153381827968230301952035301852968995773622599413891249721
| 7752834791315155748572424541506959508295331168617278558890750983
| 8175463746493931925506040092770167113900984882401285836160356370
| 7660104710181942955596198946767837449448255379774726847104047534
| 6462080466842590694912933136770289891521047521620569660240580381
| 5019351125338243003558764024749647326391419927260426992279678235
| 4781636009341721641219924586315030286182974555706749838505494588
| 5869269956909272107975093029553211653449872027559602364806654991
| 1988183479775356636980742654252786255181841757467289097777279380
| 0081647060016145249192173217214772350141441973568548161361157352
| 5521334757418494684385233239073941433345477624168625189835694855
| 6209921922218427255025425688767179049460165346680498862723279178
| 6085784383827967976681454100953883786360950680064225125205117392
| 9848960841284886269456042419652850